
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Lime
#property indicator_color2 Yellow

#property indicator_width1 2
#property indicator_width2 2

string gs_unused_76 = "First Moving Average";
extern int g_period_84 = 5;
string gs_unused_88 = "0=sma, 1=ema, 2=smma, 3=lwma";
int g_ma_method_96 = MODE_LWMA;
string gs_unused_100 = "--------------------------------------------";
string gs_unused_108 = "Second Moving Average";
extern int g_period_116 = 13;
string gs_unused_120 = "0=sma, 1=ema, 2=smma, 3=lwma";
int g_ma_method_128 = MODE_EMA;
string gs_unused_132 = "--------------------------------------------";
string gs_unused_140 = "Arrow Type";
string gs_unused_148 = "use WingDings font";
int gi_156 = SYMBOL_ARROWUP;
int gi_160 = SYMBOL_ARROWDOWN;
int gi_unused_164 = 2;
string gs_unused_168 = "--------------------------------------------";
string gs_unused_176 = "turn on Alert = true; turn off = false";
extern bool AlertOn = false;
string gs_unused_188 = "--------------------------------------------";
string gs_unused_196 = "send Email Alert = true; turn off = false";
extern bool SendAnEmail = false;
double g_ibuf_224[];
double g_ibuf_228[];
string gs_232;
string gs_240;
string gs_248;
int gi_256 = 2007;
int gi_260 = 1;
int gi_264 = 2010;
int gi_268 = 12;
int gi_unused_272 = 22;
int gi_unused_276 = 30;
datetime g_time_280;

string GetTimeFrameStr() {
   string l_timeframe_4;
   switch (Period()) {
   case PERIOD_M1:
      l_timeframe_4 = "1M";
      break;
   case PERIOD_M5:
      l_timeframe_4 = "5M";
      break;
   case PERIOD_M15:
      l_timeframe_4 = "15M";
      break;
   case PERIOD_M30:
      l_timeframe_4 = "30M";
      break;
   case PERIOD_H1:
      l_timeframe_4 = "1H";
      break;
   case PERIOD_H4:
      l_timeframe_4 = "4H";
      break;
   case PERIOD_D1:
      l_timeframe_4 = "D1";
      break;
   case PERIOD_W1:
      l_timeframe_4 = "W1";
      break;
   case PERIOD_MN1:
      l_timeframe_4 = "MN";
      break;
   default:
      l_timeframe_4 = Period();
   }
   return (l_timeframe_4);
}

int init() {
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexArrow(0, gi_156);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexArrow(1, gi_160);
   SetIndexBuffer(0, g_ibuf_224);
   SetIndexBuffer(1, g_ibuf_228);
   switch (g_ma_method_96) {
   case MODE_EMA:
      gs_240 = "Signal :";
      break;
   case MODE_SMMA:
      gs_240 = "Signal :";
      break;
   case MODE_LWMA:
      gs_240 = "Signal :";
      break;
   default:
      g_ma_method_96 = 0;
      gs_240 = "SMA";
   }
   switch (g_ma_method_128) {
   case MODE_EMA:
      gs_248 = " ";
      break;
   case MODE_SMMA:
      gs_248 = " ";
      break;
   case MODE_LWMA:
      gs_248 = " ";
      break;
   default:
      g_ma_method_128 = 0;
      gs_248 = "SMA";
   }
   gs_232 = Symbol() + " period " + GetTimeFrameStr() + "  ";
   return (0);
}

int deinit() {
   return (0);
}

int NewBar() {
   datetime l_time_0 = Time[0];
   if (g_time_280 != l_time_0) {
      g_time_280 = l_time_0;
      return (1);
   }
   return (0);
}

int start() {
   int li_8;
   double l_ima_12;
   double l_ima_20;
   double l_ima_28;
   double l_ima_36;
   double l_ima_44;
   double l_ima_52;
   double ld_60;
   double ld_68;
   if (g_period_84 > 4) {
      if (TimeYear(TimeCurrent()) < gi_256) return (0);
      if (TimeMonth(TimeCurrent()) < gi_260) return (0);
      if (TimeYear(TimeCurrent()) > gi_264) return (0);
      if (TimeMonth(TimeCurrent()) > gi_268) return (0);
   }
   int li_76 = IndicatorCounted();
   if (li_76 < 0) return (-1);
   if (li_76 > 0) li_76--;
   int li_0 = Bars - li_76;
   for (int li_4 = 0; li_4 <= li_0; li_4++) {
      li_8 = li_4;
      ld_60 = 0;
      ld_68 = 0;
      for (li_8 = li_4; li_8 <= li_4 + 9; li_8++) ld_68 += MathAbs(High[li_8] - Low[li_8]);
      ld_60 = ld_68 / 10.0;
      l_ima_12 = iMA(NULL, 0, g_period_84, 0, g_ma_method_96, PRICE_CLOSE, li_4);
      l_ima_28 = iMA(NULL, 0, g_period_84, 0, g_ma_method_96, PRICE_CLOSE, li_4 + 1);
      l_ima_44 = iMA(NULL, 0, g_period_84, 0, g_ma_method_96, PRICE_CLOSE, li_4 - 1);
      l_ima_20 = iMA(NULL, 0, g_period_116, 0, g_ma_method_128, PRICE_CLOSE, li_4);
      l_ima_36 = iMA(NULL, 0, g_period_116, 0, g_ma_method_128, PRICE_CLOSE, li_4 + 1);
      l_ima_52 = iMA(NULL, 0, g_period_116, 0, g_ma_method_128, PRICE_CLOSE, li_4 - 1);
      if (l_ima_12 > l_ima_20 && l_ima_28 < l_ima_36 && l_ima_44 > l_ima_52) {
         g_ibuf_224[li_4] = Low[li_4] - 1.5 * ld_60;
         if (AlertOn && NewBar()) Alert(gs_240 + " (( Buy )) " + ", exit sell @" + gs_248 + gs_232);
         if (SendAnEmail && NewBar()) SendMail(gs_240 + " (( Buy )) " + ", exit sell @" + gs_248 + " (" + g_period_116 + ")", gs_232);
      } else {
         if (l_ima_12 < l_ima_20 && l_ima_28 > l_ima_36 && l_ima_44 < l_ima_52) {
            g_ibuf_228[li_4] = High[li_4] + 1.5 * ld_60;
            if (AlertOn && NewBar()) Alert(gs_240 + " (( Sell )) " + ", exit buy @" + gs_248, gs_232);
            if (SendAnEmail && NewBar()) SendMail(gs_240 + " (( Sell )) " + " ,exit buy @" + gs_248, gs_232);
         }
      }
   }
/*   Comment(" \n ------------------------ HTTP:// PROFIT.TOTALH.COM ------------------------- \n    This indicator system is the best for all pair. Registered to: all user" 
      + "\n --------------------------------------------------------------------------------------------------" 
      + "\n     NOT FOR SALE, UNLIMITED!! Copyright  2006, fxsoni system." 
      + "\n                 Contact Support: sonyirwana2006@yahoo.com" 
      + "\n --------------------------------------------------------------------------------------------------" 
      + "\n    EXIT TARGET :You can set your target for 10 - 20 points or more.                                         " 
      + "\n     Warning : Let us help each other, report to me if this system error" 
   + "\n --------------------------------------------------------------------------------------------------");
*/   return (0);
}